<?php
session_name('user_session');
session_start();
require '../include/common.php';

// 检查用户是否已登录
if (!isset($_SESSION['role'])) {
    header("Location: login.php"); // 如果未登录，重定向到登录页面
    exit();
}

// 处理充值请求的逻辑
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['amounts'])) {
        $userId = $_SESSION['user_id'];
        $amount = $_POST['amounts'];
        $type = $_POST['type'];
        $orderNumber = date("YmdHis") . mt_rand(100, 999); // 生成商户订单号

        // 将充值请求记录到订单表，余额增加状态初始设为0
        $stmt = $pdo->prepare("INSERT INTO " . table('orders') . " (user_id, pay_type, amount, status, order_number) VALUES (:user_id,:pay_type, :amount, 0, :order_number)");
        $stmt->execute([
            'user_id' => $userId,
            'amount' => $amount,
            'order_number' => $orderNumber,
            'pay_type' => $type

        ]);

        /**************************请求参数**************************/
        // 获取当前域名和前缀
        $currentHost = $_SERVER['HTTP_HOST'];
        $currentScheme = $_SERVER['REQUEST_SCHEME'];
        $domain = $currentScheme . '://' . $currentHost; // 生成完整的域名
        // 向支付接口发送请求
        $url = $domain . "/other/pay/epay/epayapi.php"; // 替换为实际支付接口地址
        $postData = [
            'WIDout_trade_no' => $orderNumber,
            'product_name' => $_POST['product_name'],
            'amounts' => $amount,
            'type' => $_POST['type'],
        ];

        // 使用 cURL 发送 POST 请求到支付接口
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);

        $response = curl_exec($ch); // 获取响应结果
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // 获取HTTP响应代码
        curl_close($ch);

        // 根据需要处理支付接口的响应
        if ($httpCode == 200) { // 请求成功
            // TODO: 根据返回的响应进行后续处理，比如更新订单状态等
            echo $response; // 仅用于调试，输出支付接口的响应
            exit();
        } else {
            echo "支付请求失败，错误代码: " . $httpCode; // 错误处理
        }
    }
}
?>

<?php include 'header.php'; // 引入 header.php ?>

<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
    <h1>余额充值</h1>

    <?php if (isset($_GET['status']) && $_GET['status'] == 'success'): ?>
        <div class="alert alert-success" role="alert">
            充值成功！
        </div>
    <?php endif; ?>

    <form method="POST" action="recharge.php">
        <div class="mb-3" style="display: none;">
            <label class="form-label">商户订单号：</label>
            <input size="30" name="WIDout_trade_no" value="<?php echo date("YmdHis") . mt_rand(100, 999); ?>" readonly />
        </div>
        <div class="mb-3" style="display: none;">
            <label for="product_name" class="form-label">商品名称：</label>
            <input size="30" name="product_name" value="余额充值" />
        </div>
        <div class="mb-3">
            <label for="amounts" class="form-label">充值金额</label>
            <input class="form-control" type="number" size="30" name="amounts" step="0.01" value="1" required />
        </div>
        <div>
    <?php if (isset($apiCredentials['payment_status_alipay']) && $apiCredentials['payment_status_alipay'] == '1'): ?>
        <label><input type="radio" name="type" value="alipay" checked="">支付宝</label>
    <?php endif; ?>
    &nbsp;
    <?php if (isset($apiCredentials['payment_status_qqpay']) && $apiCredentials['payment_status_qqpay'] == '1'): ?>
        <label><input type="radio" name="type" value="qqpay">QQ钱包</label>
    <?php endif; ?>
    &nbsp;
    <?php if (isset($apiCredentials['payment_status_wechatpay']) && $apiCredentials['payment_status_wechatpay'] == '1'): ?>
        <label><input type="radio" name="type" value="wxpay">微信支付</label>
    <?php endif; ?>
    &nbsp;
    <?php if (isset($apiCredentials['payment_status_yunshanfu']) && $apiCredentials['payment_status_yunshanfu'] == '1'): ?>
        <label><input type="radio" name="type" value="bank">云闪付</label>
    <?php endif; ?>
</div>

        <button type="submit" class="btn btn-success" target="_blank">提交充值</button>
    </form>
</div>
</div>
    </div>
</body>
</html>
