<?php
session_name('user_session');
session_start();
require '../include/common.php';

// 检查用户是否已登录
if (!isset($_SESSION['role'])) {
    header("Location: login.php"); // 如果未登录，重定向到登录页面
    exit();
}
$userId = $_SESSION['user_id'];

// 查询公告，包含创建时间
$stmt = $pdo->prepare("SELECT title, message, created_at FROM " . table('announcements') . " ORDER BY created_at DESC");
$stmt->execute();
$announcements = $stmt->fetchAll();

// 查询余额
$stmt = $pdo->prepare("SELECT balance FROM " . table('users') . " WHERE id = ?");
$stmt->execute([$userId]); // 使用参数替换
$balance = $stmt->fetchColumn();

// 查询解析数量
$stmt = $pdo->prepare("SELECT COUNT(*) FROM " . table('dns_records') . " WHERE user_id = ?");
$stmt->execute([$userId]); // 使用参数替换
$dns_count = $stmt->fetchColumn();

//查询用户组可以解析的数量
$stmt = $pdo->prepare("SELECT COUNT(*) FROM " . table('group_domains') . " WHERE group_id = (SELECT group_id FROM " . table('users') . " WHERE id = ?)");
$stmt->execute([$userId]); // 使用参数替换
$group_limit = $stmt->fetchColumn();

// 查询用户组信息
$stmt = $pdo->prepare("SELECT group_name FROM " . table('user_groups') . " WHERE id = (SELECT group_id FROM " . table('users') . " WHERE id = ?)");
$stmt->execute([$userId]); // 使用参数替换
$group_name = $stmt->fetchColumn();
?>

<?php include 'header.php'; // 引入 header.php ?>

<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row mb-3"> <!-- 添加 mb-3 -->
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0 font-size-18">控制台</h4>
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">迅风DNS分发系统</a></li>
                                <li class="breadcrumb-item active">首页</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            <!-- end page title -->

            <div class="row mb-3"> <!-- 添加 mb-3 -->
                <!-- 当前余额卡片 -->
                <div class="col-xl-3 col-md-6 mb-3"> <!-- 添加 mb-3 -->
                    <div class="card card-h-100 h-100">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-6">
                                    <span class="text-muted mb-3 lh-1 d-block text-truncate">当前余额</span>
                                    <h4 class="mb-3">
                                        ￥<span class="counter-value" data-target="865.2"><?php echo $balance ?? 0; ?></span>
                                    </h4>
                                </div>
                                <div class="col-6">
                                    <div id="mini-chart1" data-colors='["#5156be"]' class="apex-charts mb-2"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- 解析数量卡片 -->
                <div class="col-xl-3 col-md-6 mb-3"> <!-- 添加 mb-3 -->
                    <div class="card card-h-100 h-100">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-6">
                                    <span class="text-muted mb-3 lh-1 d-block text-truncate">解析数量</span>
                                    <h4 class="mb-3">
                                        <span class="counter-value" data-target="12.57"><?php echo $dns_count ?? 0; ?></span>
                                    </h4>
                                </div>
                                <div class="col-6">
                                    <div id="mini-chart4" data-colors='["#5156be"]' class="apex-charts mb-2"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- 域名数卡片 -->
                <div class="col-xl-3 col-md-6 mb-3"> <!-- 添加 mb-3 -->
                    <div class="card card-h-100 h-100">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-6">
                                    <span class="text-muted mb-3 lh-1 d-block text-truncate">域名数</span>
                                    <h4 class="mb-3">
                                        <span class="counter-value" data-target="6258"><?php echo $group_limit ?? 0; ?></span>
                                    </h4>
                                </div>
                                <div class="col-6">
                                    <div id="mini-chart2" data-colors='["#5156be"]' class="apex-charts mb-2"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- 当前用户组卡片 -->
                <div class="col-xl-3 col-md-6 mb-3"> <!-- 添加 mb-3 -->
                    <div class="card card-h-100 h-100">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-6">
                                    <span class="text-muted mb-3 lh-1 d-block text-truncate">当前用户组</span>
                                    <h4 class="mb-3">
                                        <span class="counter-value" data-target="4.32"><?php echo $group_name ?? 0; ?></span>
                                    </h4>
                                </div>
                                <div class="col-6">
                                    <div id="mini-chart3" data-colors='["#5156be"]' class="apex-charts mb-2"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mb-3"> 
    <div class="col-xl-3 col-md-6">
        <div class="card card-h-100 h-100">
            <div class="card-body">
                <div class="dropdown text-end">
                    <a class="text-muted dropdown-toggle font-size-16" href="#" role="button" data-bs-toggle="dropdown" aria-haspopup="true">
                        <i class="bx bx-dots-horizontal-rounded"></i>
                    </a>
                    <div class="dropdown-menu dropdown-menu-end">
                        <a class="dropdown-item" href="profile.php">修改资料</a>
                        <a class="dropdown-item" href="login.php?action=logout">退出登录</a>
                    </div>
                </div>

                <div class="avatar-xl mx-auto mb-4">
                    <div class="avatar-title bg-light-subtle text-light display-4 m-0 rounded-circle">
                        <?php if (!empty($user['qq'])): ?>
                            <img class="avatar-title bg-light-subtle text-light display-4 m-0 rounded-circle" src="https://q2.qlogo.cn/headimg_dl?dst_uin=<?php echo htmlspecialchars($user['qq']); ?>&&spec=640" alt="Header Avatar">
                        <?php else: ?>
                            <i class="bx bxs-user-circle rounded-circle"></i>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="text-center">
                    <h5 class="font-size-16 mb-1"><a href="#" class="text-body"><?php echo htmlspecialchars($user['username'] ?? ''); ?></a></h5>
                    <p class="text-muted mb-2"><?php echo htmlspecialchars($user['email'] ?? ''); ?></p>
                </div>
            </div>

            <div class="btn-group" role="group">
                <a href="dns.php" class="btn btn-outline-light text-truncate">
                    <i class="uil uil-user me-1"></i> 域名解析
                </a>
                <a href="recharge.php" class="btn btn-outline-light text-truncate">
                    <i class="uil uil-envelope-alt me-1"></i> 余额充值
                </a>
            </div>
        </div>
    </div>
</div>

        </div>
    </div>
</div>

</div>
</body>

</html>