<?php
require_once '../include/common.php';

// 确保会话已启动
if (session_status() == PHP_SESSION_NONE) {
    session_name('user_session');
    session_start();
}

// 确保用户已登录
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$userId = $_SESSION['user_id'];
$apikey = $apiCredentials['web_apikey'];

// 获取用户信息
$stmt = $pdo->prepare("SELECT * FROM " . table('users') . " WHERE id = :id");
$stmt->execute(['id' => $userId]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

// 检查用户信息是否获取成功
if (!$user) {
    header("Location: login.php");
    exit();
}

// 检查用户角色
$isAdmin = isset($_SESSION['role']) && $_SESSION['role'] == 1;

?>
<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <title>用户管理中心</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    <link rel="shortcut icon" href="../assets/images/favicon.ico">
    <link href="../assets/libs/admin-resources/jquery.vectormap/jquery-jvectormap-1.2.2.css" rel="stylesheet"
        type="text/css" />
    <link rel="stylesheet" href="../assets/css/preloader.min.css" type="text/css" />
    <link href="../assets/css/bootstrap.min.css" id="bootstrap-style" rel="stylesheet" type="text/css" />
    <link href="../assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <link href="../assets/css/app.min.css" id="app-style" rel="stylesheet" type="text/css" />
</head>

<body>
    <div id="layout-wrapper">
        <header id="page-topbar">
            <div class="navbar-header">
                <div class="d-flex">
                    <div class="navbar-brand-box">
                        <a href="." class="logo logo-dark">
                            <span class="logo-sm">
                                <img src="../assets/images/logo-sm.svg" alt="" height="24">
                            </span>
                            <span class="logo-lg">
                                <img src="../assets/images/logo-sm.svg" alt="" height="24"> <span
                                    class="logo-txt"><?php echo $currentSettings['site_name']; ?></span>
                            </span>
                        </a>
                        <a href="." class="logo logo-light">
                            <span class="logo-sm">
                                <img src="../assets/images/logo-sm.svg" alt="" height="24">
                            </span>
                            <span class="logo-lg">
                                <img src="../assets/images/logo-sm.svg" alt="" height="24"> <span
                                    class="logo-txt"><?php echo $currentSettings['site_name']; ?></span>
                            </span>
                        </a>
                    </div>
                    <button type="button" class="btn btn-sm px-3 font-size-16 header-item" id="vertical-menu-btn">
                        <i class="fa fa-fw fa-bars"></i>
                    </button>
                    <form class="app-search d-none d-lg-block">
                        <div class="position-relative">
                            <input type="text" class="form-control" placeholder="Search...">
                            <button class="btn btn-primary" type="button"><i
                                    class="bx bx-search-alt align-middle"></i></button>
                        </div>
                    </form>
                </div>
                <div class="d-flex">
                    <div class="dropdown d-inline-block d-lg-none ms-2">
                        <button type="button" class="btn header-item" id="page-header-search-dropdown"
                            data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i data-feather="search" class="icon-lg"></i>
                        </button>
                        <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end p-0"
                            aria-labelledby="page-header-search-dropdown">
                            <form class="p-3">
                                <div class="form-group m-0">
                                    <div class="input-group">
                                        <input type="text" class="form-control" placeholder="Search ..."
                                            aria-label="Search Result">

                                        <button class="btn btn-primary" type="submit"><i
                                                class="mdi mdi-magnify"></i></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="dropdown d-inline-block">
                        <button type="button" class="btn header-item" id="mode-setting-btn">
                            <i data-feather="moon" class="icon-lg layout-mode-dark"></i>
                            <i data-feather="sun" class="icon-lg layout-mode-light"></i>
                        </button>
                    </div>
                    <?php include_once('notice.php'); ?>
                    <div class="dropdown d-inline-block">
                        <button type="button" class="btn header-item bg-light-subtle border-start border-end"
                            id="page-header-user-dropdown" data-bs-toggle="dropdown" aria-haspopup="true"
                            aria-expanded="false">
                            <?php if (!empty($user['qq'])): ?>
                                <img class="rounded-circle header-profile-user"
                                    src="https://q2.qlogo.cn/headimg_dl?dst_uin=<?php echo htmlspecialchars($user['qq']); ?>&&spec=640"
                                    alt="Header Avatar">
                            <?php else: ?>
                                <i class="bx bxs-user-circle"></i>
                            <?php endif; ?>

                            <span
                                class="d-none d-xl-inline-block ms-1 fw-medium"><?php echo htmlspecialchars($user['username'] ?? ''); ?></span>
                            <i class="mdi mdi-chevron-down d-none d-xl-inline-block"></i>
                        </button>
                        <div class="dropdown-menu dropdown-menu-end">
                            <a class="dropdown-item" href="profile.php"><i
                                    class="mdi mdi mdi-face-man font-size-16 align-middle me-1"></i> 修改资料</a>
                            <!-- <a class="dropdown-item" href="auth-lock-screen.html"><i class="mdi mdi-lock font-size-16 align-middle me-1"></i> Lock Screen</a> -->
                            <div class="dropdown-divider"></div>
                            <a class="dropdown-item" href="login.php?action=logout"><i
                                    class="mdi mdi-logout font-size-16 align-middle me-1"></i> 登出</a>
                        </div>
                    </div>
                </div>
            </div>
        </header>
        <div class="vertical-menu">
            <div data-simplebar class="h-100">
                <div id="sidebar-menu">
                    <ul class="metismenu list-unstyled" id="side-menu">
                        <li class="menu-title" data-key="t-menu">菜单</li>
                        <li>
                            <a href=".">
                                <i data-feather="home"></i>
                                <span data-key="t-dashboard">主页</span>
                            </a>
                        </li>
                        <li>
                            <a href="dns.php">
                                <i data-feather="users"></i>
                                <span data-key="t-authentication">解析列表</span>
                            </a>
                        </li>
                        <li>
                            <a href="javascript: void(0);" class="has-arrow">
                                <i data-feather="layout"></i>
                                <span data-key="t-pages">个人资料</span>
                            </a>
                            <ul class="sub-menu" aria-expanded="false">
                                <li><a href="profile.php" data-key="t-starter-page">修改资料</a></li>
                                <li><a href="profile.php?verify=email" data-key="t-maintenance">修改邮箱</a></li>
                                <li><a href="profile.php?verify=mobile" data-key="t-maintenance">修改手机</a></li>
                                <li><a href="profile.php?realname" data-key="t-coming-soon">实名修改</a></li>
                            </ul>
                        </li>
                        <li>
                            <a href="orders.php">
                                <i data-feather="file-text"></i>
                                <span data-key="t-horizontal">订单管理</span>
                            </a>
                        </li>
                        <li>
                            <a href="recharge.php">
                                <i data-feather="folder-minus"></i>
                                <span data-key="t-horizontal">余额充值</span>
                            </a>
                        </li>
                        <?php if ($isAdmin): ?>
                            <li class="menu-title mt-2" data-key="t-components">SPDNS</li>
                            <li>
                                <a href="profile.php?apikey">
                                    <i data-feather="codesandbox"></i>
                                    <span data-key="t-components">api密钥</span>
                                </a>
                            </li>
                            <li>
                                <a href="exchange.php">
                                    <i data-feather="credit-card"></i>
                                    <span data-key="t-ui-elements">卡密兑换</span>
                                </a>
                            </li>
                            <li>
                                <a href="tickets.php">
                                    <i data-feather="grid"></i>
                                    <span data-key="t-apps">工单管理</span>
                                </a>
                            </li>
                            <li>
                                <a href="groups.php">
                                    <i data-feather="box"></i>
                                    <span data-key="t-forms">购买会员</span>
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                    <!-- <div class="card sidebar-alert border-0 text-center mx-4 mb-0 mt-5">
                        <div class="card-body">
                            <img src="../assets/images/giftbox.png" alt="">
                            <div class="mt-4">
                                <h5 class="alertcard-title font-size-16">一份礼包！</h5>
                                <p class="font-size-13">从免费试用版升级到选择‘商业计划’。</p>
                                <a href="#!" class="btn btn-primary mt-2">现在领取</a>
                            </div>
                        </div>
                    </div> -->
                </div>
            </div>
        </div>
        <?php include_once('footer.php'); ?>
        <?php include_once('right_bar.php'); ?>
        <div class="rightbar-overlay"></div>
        <script src="../assets/libs/jquery/jquery.min.js"></script>
        <script src="../assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
        <!-- <script src="../assets/js/popper.min.js"></script> -->
        <script src="../assets/libs/metismenu/metisMenu.min.js"></script>
        <script src="../assets/libs/simplebar/simplebar.min.js"></script>
        <script src="../assets/libs/node-waves/waves.min.js"></script>
        <script src="../assets/libs/feather-icons/feather.min.js"></script>
        <script src="../assets/libs/pace-js/pace.min.js"></script>
        <script src="../assets/libs/apexcharts/apexcharts.min.js"></script>
        <script src="../assets/libs/admin-resources/jquery.vectormap/jquery-jvectormap-1.2.2.min.js"></script>
        <script src="../assets/libs/admin-resources/jquery.vectormap/maps/jquery-jvectormap-world-mill-en.js"></script>
        <script src="../assets/js/pages/dashboard.init.js"></script>
        <script src="../assets/js/app.js"></script>
</body>

</html>