<?php
error_reporting(E_ALL); // 开启所有错误报告以便调试
session_name('user_session');
session_start();
@header('Content-Type: text/html; charset=UTF-8');

include '../other/oauth/uniauth/Oauthbind.config.php';
include '../other/oauth/uniauth/Oauth.class.php';

// 检查用户是否已登录
if (!isset($_SESSION['user_id'])) {
    exit("<script>alert('您还未登录，请先登录。'); window.location.href='./login.php';</script>");
}

// 检查是否需要解绑
if (isset($_GET['type']) && preg_match('/^unbind_/', $_GET['type'])) {
    $userId = $_SESSION['user_id']; // 当前用户 ID
    $type = $_GET['type'];

    try {
        global $pdo;
        
        if ($type === 'unbind_qq') {
            $stmt = $pdo->prepare("UPDATE " . table('users') . " SET qq_uid = NULL WHERE id = :id");
            $stmt->execute(['id' => $userId]);

            $_SESSION['user']['social_uid'] = null;
            
        } elseif ($type === 'unbind_wx') {
            $stmt = $pdo->prepare("UPDATE " . table('users') . " SET wx_uid = NULL WHERE id = :id");
            $stmt->execute(['id' => $userId]);

            $_SESSION['user']['social_uid'] = null;
            
        } elseif ($type === 'unbind_alipay') {
            $stmt = $pdo->prepare("UPDATE " . table('users') . " SET alipay_uid = NULL WHERE id = :id");
            $stmt->execute(['id' => $userId]);

            $_SESSION['user']['social_uid'] = null;
            
        } else {
            exit("<script>alert('无效的解绑类型。'); window.location.href='./profile.php';</script>");
        }

        if ($stmt->rowCount() > 0) {
            exit("<script>alert('解绑成功！'); window.location.href='./profile.php';</script>");
        } else {
            exit("<script>alert('未找到相关账号或解绑失败。'); window.location.href='./profile.php';</script>");
        }

    } catch (PDOException $e) {
        exit("<script>alert('解绑失败：" . $e->getMessage() . "'); window.location.href='./profile.php';</script>");
    }
}


// 原有的 OAuth 登录逻辑
$type = isset($_GET['type']) ? $_GET['type'] : 'qq';

if (isset($_GET['code'])) {
    if ($_GET['state'] != $_SESSION['Oauth_state']) {
        exit("The state does not match. You may be a victim of CSRF.");
    }
    $Oauth = new Oauth($Oauth_config);
    $arr = $Oauth->callback();
    if (isset($arr['code']) && $arr['code'] == 0) {
        $code = $arr['code'];
        $openid = $arr['social_uid'];
        $access_token = $arr['access_token'];
        $type = $arr['type'];
        /* 处理用户登录逻辑 */

        $_SESSION['user'] = $arr;
        exit("<script language='javascript'>window.location.href='./profile.php';</script>");

    } elseif (isset($arr['code'])) {
        exit('登录失败，返回错误原因：' . $arr['msg']);
    } else {
        exit('获取登录数据失败');
    }
} else {
    $Oauth = new Oauth($Oauth_config);
    $arr = $Oauth->login($type);
    if (isset($arr['code']) && $arr['code'] == 0) {
        exit("<script language='javascript'>window.location.href='{$arr['url']}';</script>");
    } elseif (isset($arr['code'])) {
        exit('登录接口返回：' . $arr['msg']);
    } else {
        exit('获取登录地址失败');
    }
}
