<?php
session_name('user_session');
session_start();

// 创建图像
$width = 100;
$height = 40;
$image = imagecreatetruecolor($width, $height);

// 生成随机验证码
$characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
$captcha_code = substr(str_shuffle($characters), 0, 4);
$_SESSION['captcha_code'] = $captcha_code; // 存储验证码到会话中

// 设置颜色
$background_color = imagecolorallocate($image, 248, 249, 250); // 背景色
$text_color = imagecolorallocate($image, 0, 0, 0); // 黑色文字
$line_color = imagecolorallocate($image, 0, 0, 0); // 干扰线颜色

// 填充背景
imagefilledrectangle($image, 0, 0, $width, $height, $background_color);

// 在画布上绘制干扰线
for ($i = 0; $i < 5; $i++) {
    imageline($image, rand(0, $width), rand(0, $height), rand(0, $width), rand(0, $height), $line_color);
}

// 在画布上绘制噪音点
for ($i = 0; $i < 50; $i++) {
    imagesetpixel($image, rand(0, $width), rand(0, $height), $line_color);
}

// 在画布上绘制验证码
$font_size = 20;

// 计算验证码的中心位置
$x = ($width / 2) - (strlen($captcha_code) * $font_size / 5); 
$y = ($height / 2) + ($font_size / 2);

// 使用默认字体绘制验证码
imagestring($image, 5, $x, $y - 10, $captcha_code, $text_color); // 使用默认字体绘制验证码

// 输出图像
header('Content-Type: image/png');
imagepng($image);
imagedestroy($image);
?>
