<?php
require '../include/common.php';
require '../other/mail/vendor/autoload.php';

require '../other/mail/vendor/phpmailer/phpmailer/src/PHPMailer.php';
require '../other/mail/vendor/phpmailer/phpmailer/src/Exception.php';
require '../other/mail/vendor/phpmailer/phpmailer/src/SMTP.php';

header('Content-Type: application/json');

// 定义全局变量
global $email_host, $email_port, $email_username, $email_password;

$email_host = $apiCredentials['email_host'];
$email_port = $apiCredentials['email_port'];
$email_username = $apiCredentials['email_username'];
$email_password = $apiCredentials['email_password'];
$site_name = $currentSettings['site_name'];

/**
 * 发送 SMTP 邮件
 *
 * @param string $to 收件人地址
 * @param string $subject 邮件主题
 * @param string $body 邮件内容
 * @return bool 返回是否发送成功
 */
function sendSMTPMail($to, $subject, $body)
{
    global $email_host, $email_port, $email_username, $email_password, $site_name; // 使用全局变量

    $mail = new PHPMailer\PHPMailer\PHPMailer(true); // 实例化 PHPMailer

    try {
        // 服务器设置
        $mail->isSMTP(); // 使用 SMTP
        $mail->Host = $email_host; // SMTP 服务器地址
        $mail->SMTPAuth = true; // 开启 SMTP 认证
        $mail->Username = $email_username; // SMTP 用户名
        $mail->Password = $email_password; // SMTP 密码
        $mail->SMTPSecure = PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_STARTTLS; // 启用 TLS 加密
        $mail->Port = $email_port; // TCP 端口

        // 收件人设置
        $mail->setFrom($email_username, $site_name); // 请替换为您的发件人名称
        $mail->addAddress($to); // 添加收件人

        // 邮件内容
        $mail->isHTML(true); // 是否以 HTML 格式发送邮件
        $mail->Subject = $subject; // 邮件主题
        $mail->Body = $body; // 邮件内容
        $mail->AltBody = strip_tags($body); // 备用邮件内容（纯文本）

        // 发送邮件
        $mail->send();
        return true;
    } catch (Exception $e) {
        error_log("邮件发送失败: {$mail->ErrorInfo}");
        return false;
    }
}

/**
 * 发送邮箱验证码
 *
 * @param string $email 邮箱地址
 * @return array 返回发送结果
 */
function sendVerificationCode($email)
{
    // 检查是否在最近60秒内发送过验证码
    if (isset($_SESSION['last_sent_time']) && time() - $_SESSION['last_sent_time'] < 60) {
        return ['success' => false, 'message' => '每个邮箱每分钟只能发送一次验证码。'];
    }

    $code = rand(100000, 999999); // 生成六位随机验证码
    $subject = '您的验证码';
    $body = '您的邮箱验证码是：' . $code;

    if (sendSMTPMail($email, $subject, $body)) {
        $_SESSION['verification_code'] = $code; // 保存验证码到session
        $_SESSION['last_sent_time'] = time(); // 记录发送时间
        return ['success' => true, 'message' => '验证码已发送到您的邮箱。'];
    } else {
        return ['success' => false, 'message' => '发送验证码失败。'];
    }
}

/**
 * 发送短信数据
 *
 * @param string $sms_url 短信接口 URL
 * @param array $sms_data 短信数据
 * @return mixed 返回请求响应
 */
function post_smsdata($sms_url, $sms_data)
{
    $ch = curl_init(); // 初始化 cURL
    if ($ch === false) {
        error_log('无法初始化 cURL');
        return ['success' => false, 'message' => '无法初始化 cURL'];
    }

    curl_setopt($ch, CURLOPT_URL, $sms_url); // 设置请求的 URL
    curl_setopt($ch, CURLOPT_POST, true); // 设置为 POST 请求
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($sms_data)); // 将数据编码为 JSON
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // 返回转储的字符串，而不是直接输出
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json')); // 设置请求头为 JSON

    $response = curl_exec($ch); // 执行 cURL 请求

    if ($response === false) {
        error_log("cURL 执行失败: " . curl_error($ch)); // 处理错误
        return ['success' => false, 'message' => 'cURL 执行失败: ' . curl_error($ch)];
    }

    curl_close($ch); // 关闭 cURL 句柄
    return $response; // 返回响应
}

// 检查 AJAX 请求
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    session_name('user_session');
    session_start();

    // 解析 JSON 输入
    $input = json_decode(file_get_contents('php://input'), true);

    // 验证密钥
    if (!isset($input['secret_key']) || $input['secret_key'] !== $_SESSION['secret_key']) {
        echo json_encode(['success' => false, 'message' => '密钥验证失败。']);
        exit;
    }

    // 处理自定义发送邮件请求
    if (isset($input['to'], $input['subject'], $input['body'])) {
        $to = $input['to'];
        $subject = $input['subject'];
        $body = $input['body'];
        $success = sendSMTPMail($to, $subject, $body);
        echo json_encode(['success' => $success, 'message' => $success ? '邮件发送成功！' : '邮件发送失败！']);
        exit;
    }

    // 检查发送验证码的逻辑
    if (isset($input['email'])) {
        // 发送邮箱验证码部分
        $email = $input['email'];

        echo json_encode(sendVerificationCode($email));
        exit;
    }

    if (isset($input['mobile'])) {
        // 处理手机验证码请求
        $mobile = $input['mobile'];
        $code = rand(100000, 999999); // 生成六位随机验证码

        // 准备 SMS 数据
        $sms_data = array(
            'mobile' => $mobile,
            'message' => 'sendcode' . $code // 将验证码拼接到消息
        );

        // 短信发送接口 URL
        $sms_provider = $currentSettings['sms_interface']; // 短信服务供应商
        $web_apikey = $apiCredentials['web_apikey'];
        $sms_url = $Website_Url . "/other/sms/" . $sms_provider . "/index.php?apikey=" . $web_apikey;

        // 发送短信请求
        $response = post_smsdata($sms_url, $sms_data); // 调用发送短信的函数，发送验证码
        $responseData = json_decode($response, true); // 假设 SMS 接口返回 JSON 格式

        // 检查发送是否成功
        if (!empty($responseData) && isset($responseData['code']) && $responseData['code'] == 200) {
            // 发送成功
            $_SESSION['verification_code'] = $code; // 保存验证码到session

            // 返回发送结果
            echo json_encode([
                'success' => true,
                'message' => '短信验证码已发送！',
            ]);
        } else {
            // 发送失败
            error_log("短信发送失败: " . json_encode($responseData));
            echo json_encode([
                'success' => false,
                'message' => '短信验证码发送失败！'
            ]);
        }
        exit;
    }

    // 如果请求的数据既没有 mobile 也没有 email
    echo json_encode(['success' => false, 'message' => '无效的请求数据。']);
} else {
    echo json_encode(['success' => false, 'message' => '无效的请求方式。']);
}
?>
