<?php
require_once 'include/common.php';
?>
<!DOCTYPE html>
<html lang="zh-CN">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://unpkg.com/boxicons@latest/css/boxicons.min.css">
    <link rel="stylesheet" href="./template/default/assets/css/swiper-bundle.min.css">
    <link rel="stylesheet" href="./template/default/assets/css/styles.css">
    <meta name="keywords" content="<?php echo $currentSettings['site_keywords'];?>">
    <title><?php echo $currentSettings['site_name'];?></title>
</head>

<body>
    <header class="header" id="header">
        <nav class="nav container">
            <a href="#" class="nav__logo">
                <img src="./assets/images/logo-sm.svg" alt="" class="nav__logo-img">
                <?php echo $currentSettings['site_name'];?>
            </a>

            <div class="nav__menu" id="nav-menu">
                <ul class="nav__list">
                    <li class="nav__item">
                        <a href="#home" class="nav__link active-link">首页</a>
                    </li>
                    <li class="nav__item">
                        <a href="https://flowus.cn/share/af4f5aed-599d-437f-9024-99f382bcbad6?embed=true" class="nav__link">开发文档</a>
                    </li>
                    <li class="nav__item">
                        <a href="user" class="nav__link">用户中心</a>
                    </li>
                    
                </ul>

                <div class="nav__close" id="nav-close">
                    <i class='bx bx-x'></i>
                </div>

                <img src="./template/default/assets/img/nav-light.png" alt="" class="nav__img">
            </div>
            <div class="nav__btns">
                <i class='bx bx-moon change-theme' id="theme-button"></i>

                <div class="nav__toggle" id="nav-toggle">
                    <i class='bx bx-grid-alt'></i>
                </div>
            </div>

        </nav>
    </header>

    <main class="main">
        <section class="home" id="home">
            <div class="home__container container grid">
                <img src="./template/default/assets/img/home.png" alt="" class="home__img">

                <div class="home__data">
                    <h1 class="home__title"><?php echo $currentSettings['site_name'];?></h1>
                    <p class="home__description">
                    <?php echo $currentSettings['site_description'];?>
                    </p>
                    <a href="#" class="button">用户中心</a>
                </div>
            </div>
        </section>
        <section class="giving section container">
            <h2 class="section__title">
                多种插件，<br> 随时对接
            </h2>

            <div class="giving__container grid">
                <div class="giving__content">
                    <img src="./assets/images/aliyun.svg" alt="阿里云" class="giving__img">
                    <h3 class="giving__title">阿里云</h3>
                </div>

                <div class="giving__content">
                    <img src="./assets/images/txyun.svg" alt="腾讯云" class="giving__img">
                    <h3 class="giving__title">腾讯云</h3>
                </div>

                <div class="giving__content">
                    <img src="./assets/images/dnsla.svg" alt="帝恩爱斯" class="giving__img">
                    <h3 class="giving__title">帝恩爱斯</h3>
                </div>

                <div class="giving__content">
                    <img src="./assets/images/west.svg" alt="西部数码" class="giving__img">
                    <h3 class="giving__title">西部数码</h3>
                </div>

                <div class="giving__content">
                    <img src="./assets/images/cloudflare.svg" alt="Cloudflare" class="giving__img">
                    <h3 class="giving__title">Cloudflare</h3>
                </div>

                <div class="giving__content">
                    <img src="./assets/images/logo-sm.svg" alt="同系统" class="giving__img">
                    <h3 class="giving__title">同系统</h3>
                </div>
            </div>

        </section>

        <section class="celebrate section container" id="celebrate">
            <div class="celebrate__container grid">
                <div class="celebrate__data">
                    <h2 class="section__title celebrate__title">
                        开放式API
                    </h2>
                    <p class="celebrate__description">
                        不同系统进行对接，<br> 实现开放式API接口
                    </p>
                    <a href="https://flowus.cn/share/af4f5aed-599d-437f-9024-99f382bcbad6?embed=true" class="button">查看文档</a>
                </div>

                <img src="./template/default/assets/img/celebrate.png" alt="" class="celebrate__img">
            </div>
        </section>

        <section class="new section container" id="new">
            <h2 class="section__title">一站式处理</h2>

            <div class="new__container">
                <div class="swiper new-swiper">
                    <div class="swiper-wrapper">
                        <article class="new__card swiper-slide">
                            <div class="new__overlay"></div>

                            <img src="./template/default/assets/img/new1.png" alt="" class="new__img">
                            <h3 class="new__price">添加</h3>

                            <button class="button new__button">
                                <i class='bx bx-heart new__icon'></i>
                            </button>
                        </article>

                        <article class="new__card swiper-slide">
                            <div class="new__overlay"></div>

                            <img src="./template/default/assets/img/new2.png" alt="" class="new__img">
                            <h3 class="new__price">编辑</h3>

                            <button class="button new__button">
                                <i class='bx bx-heart new__icon'></i>
                            </button>
                        </article>

                        <article class="new__card swiper-slide">
                            <div class="new__overlay"></div>

                            <img src="./template/default/assets/img/new3.png" alt="" class="new__img">
                            <h3 class="new__price">删除</h3>

                            <button class="button new__button">
                                <i class='bx bx-heart new__icon'></i>
                            </button>
                        </article>

                    </div>

                    <div class="swiper-pagination"></div>
                </div>
            </div>
        </section>
    <footer class="footer section">
        <div class="footer__container container grid">
            <div>
                <a href="#" class="footer__logo">
                    <img src="./assets/images/logo-sm.svg" alt="" class="footer__logo-img">
                    <?php echo $currentSettings['site_name'];?>
                </a>

                <p class="footer__description">
                    一站式DNS分发
                </p>
            </div>

            <div>
                <h3 class="footer__title">我们的服务</h3>

                <ul class="footer__links">
                    <li>
                        <a href="#" class="footer__link">价格</a>
                    </li>
                    <li>
                        <a href="#" class="footer__link">会员</a>
                    </li>
                </ul>
            </div>

            <div>
                <h3 class="footer__title">支持</h3>

                <ul class="footer__links">
                    <li>
                        <a href="#" class="footer__link">常见问题</a>
                    </li>
                    <li>
                        <a href="#" class="footer__link">支持中心</a>
                    </li>
                    <li>
                        <a href="<?php echo $currentSettings['site_qq_group'];?>" class="footer__link">QQ群</a>
                    </li>
                </ul>
            </div>


            <img src="./template/default/assets/img/footer1.png" alt="" class="footer__img1">
            <img src="./template/default/assets/img/footer2.png" alt="" class="footer__img2">
        </div>
        <span class="footer__copy">&#169; copyright <?php echo $currentSettings['site_name'];?>. All rights reserved.</span>
        <span class="footer__copy" style="margin-top: 10px">&#169; ICP备案:<?php echo $currentSettings['icp'];?></span>
    </footer>

    <a href="#" class="scrollup" id="scroll-up">
        <i class='bx bx-up-arrow-alt scrollup__icon'></i>
    </a>

    <script src="./template/default/assets/js/scrollreveal.min.js"></script>

    <script src="./template/default/assets/js/swiper-bundle.min.js"></script>

    <script src="./template/default/assets/js/main.js"></script>
</body>

</html>