<?php
require_once 'include/common.php';
$apiUrl = "https://bing.fullpx.com/bing/today";
$apiResponse = file_get_contents($apiUrl);

$apiData = json_decode($apiResponse, true);

if ($apiData['success'] && isset($apiData['data']['fhdUrl'])) {
	$fhdUrl = $apiData['data']['fhdUrl'];
} else {
	$fhdUrl = "./template/cool/images/banner1.jpg";
}
?>

<!DOCTYPE html>
<html lang="zh-CN">

<head>
	<meta charset="utf-8">
	<title><?php echo $currentSettings['site_name']; ?></title>
	<link rel="stylesheet" type="text/css" href="./template/cool/css/style.css" />
	<link rel="stylesheet" type="text/css" href="./template/cool/css/common.css">
	<link rel="stylesheet" href="http://www.5imoban.net/download/swiper/swiper-4.4.2.min.css" />
	<link rel="stylesheet" type="text/css" href="./template/cool/css/animate.min.css">

</head>

<body>
	<div class="index-header clearfix">
		<div class="index-logo fl">
			<a href="">
				<img src="./assets/images/logo-sm.svg" style="width: 56px; vertical-align: middle;">
			</a>
			<span
				style="vertical-align: middle; margin-left: 10px; font-size: 20px;"><?php echo $currentSettings['site_name']; ?></span>
		</div>

		<div class="index-header-right fr" style="display: flex; align-items: center;">
			<ul class="index-nav" style="display: flex; list-style: none; margin: 0; padding: 0;">
				<li style="margin-right: 64px;"><a href="#" style="width: 64px;">首页</a></li>
				<li><a href="user" style="width: 72px;">用户中心</a></li>
			</ul>
		</div>

		<div class="clear"></div>
	</div>


	<div class="search_sec">
		<a href="#" title="" class="close-search"><i class=" la-close"><img src="images/icon5.png"></i></a>
		<div class="search_field">
			<div class="container">
				<form>
					<input type="text" name="search" placeholder="Search for...">
					<button type="submit"><img src="./template/cool/images/search2.png" alt=""></button>
				</form>
			</div>
		</div>
	</div>

	<div id="bloc">
		<article id="index">
			<div class="banner-position">
				<div class="index-banner swiper-container">
					<div class="swiper-wrapper">
						<div class="swiper-slide">
							<img src="<?php echo $fhdUrl; ?>">
						</div>
						<div class="swiper-slide">
							<img src="<?php echo $fhdUrl; ?>">
						</div>
						<div class="swiper-slide">
							<img src="<?php echo $fhdUrl; ?>">
						</div>
					</div>
					<!-- Add Navigation -->
					<div class="swiper-button-prev swiper-button-white"></div>
					<div class="swiper-button-next swiper-button-white"></div>
				</div>
				<div class="banner-wave">
					<svg viewBox="0 0 120 28">

						<defs>

							<filter id="goo">

								<feGaussianBlur in="SourceGraphic" stdDeviation="1" result="blur" />

								<feColorMatrix in="blur" mode="matrix" values="
			
							   1 0 0 0 0  
							
							   0 1 0 0 0  
							
							   0 0 1 0 0  
							
							   0 0 0 13 -9" result="goo" />

								<xfeBlend in="SourceGraphic" in2="goo" />

							</filter>

							<path id="wave"
								d="M 0,10 C 30,10 30,15 60,15 90,15 90,10 120,10 150,10 150,15 180,15 210,15 210,10 240,10 v 28 h -240 z" />

						</defs>

						<use id="wave3" class="wave" xlink:href="#wave" x="0" y="-2"></use>

						<use id="wave2" class="wave" xlink:href="#wave" x="0" y="0"></use>

					</svg>
				</div>
			</div>
			<div class="clear"></div>

			<div class="index-yewu">
				<div class="index-con clearfix">
					<div class="index-title">
						<h3>支持接口</h3>
						<h2>All</h2>
					</div>

					<div class="index-yewu-info clearfix">
						
						<ul class="index-yewu-list clearfix fr">
							<li>
								<a href="">
									<em><img src="./assets/images/aliyun.svg"></em>
									<div class="text">
										<h2>阿里云</h2>
									</div>
									<div class="button bz-buttonAnimat clockwise both">
										<div class="inner"></div>
									</div>
								</a>
							</li>
							<li>
								<a href="">
									<em> <img src="./assets/images/txyun.svg"></em>
									<div class="text">
										<h2>腾讯云</h2>
									</div>
									<div class="button bz-buttonAnimat clockwise both">
										<div class="inner"></div>
									</div>
								</a>
							</li>
							<li>
								<a href="">
									<em><img src="./assets/images/dnsla.svg" style="width: 32px;" height="32px"></em>
									<div class="text">
										<h2>帝恩爱斯</h2>
									</div>
									<div class="button bz-buttonAnimat clockwise both">
										<div class="inner"></div>
									</div>
								</a>
							</li>
							<li>
								<a href="">
									<em><img src="./assets/images/west.svg"></em>
									<div class="text">
										<h2>西部数码</h2>
									</div>
									<div class="button bz-buttonAnimat clockwise both">
										<div class="inner"></div>
									</div>
								</a>
							</li>
							<li>
								<a href="">
									<em><img src="./assets/images/cloudflare.svg"></em>
									<div class="text">
										<h2>Cloudflare</h2>
									</div>
									<div class="button bz-buttonAnimat clockwise both">
										<div class="inner"></div>
									</div>
								</a>
							</li>
							<li>
								<a href="">
									<em><img src="./assets/images/logo-sm.svg" style="width: 32px;" height="32px"></em>
									<div class="text">
										<h2>同系统</h2>
									</div>
									<div class="button bz-buttonAnimat clockwise both">
										<div class="inner"></div>
									</div>
								</a>
							</li>
						</ul>
					</div>
				</div>
			</div>
			<div class="clear"></div>

			<div class="position-yuan clearfix">
				<div class="bg scr-el" data-v="1" data-speed-x="12" data-offset="150 "></div>
			</div>
			<div class="clear"></div>
			<div class="index-footer">
				<div class="clearfix index-footer-info index-con">
					<div class="logo fl">
						<img src="./assets/images/logo-sm.svg" style="width: 56px; vertical-align: middle;">
					</div>
					<div class="lianxi fl">
						<a href="<?php echo $currentSettings['site_qq_group']; ?>">QQ群</a>
					</div>
				</div>

				<div class="index-footer-bottom">
					<div class="index-con clearfix">
						<p class="fl"><?php echo $currentSettings['site_name']; ?>版权所有 © 2025
							ICP备案:<?php echo $currentSettings['icp']; ?></p>
					</div>
				</div>
			</div>
			<div class="clear"></div>
		</article>
	</div>

	<script type="text/javascript" src="../assets/js/jquery.min.js"></script>
	<script type="text/javascript" src='./template/cool/js/modernizr.custom.js'></script>
	<script src="./template/cool/js/more.js"></script>
	<script src="http://www.5imoban.net/download/swiper/swiper-4.4.2.min.js"></script>
	<script type="text/javascript" src="./template/cool/js/main.js"></script>
	<script type='text/javascript' src='./template/cool/js/base.js'></script>
	<script type="text/javascript" src='./template/cool/js/app.js'></script>
	<script>
		var swiper = new Swiper('.index-banner.swiper-container', {
			speed: 600,
			parallax: true,
			navigation: {
				nextEl: '.swiper-button-next',
				prevEl: '.swiper-button-prev',
			},
		});
		scrolly.init({
			wrapper: '#bloc',
			targets: '.scr-el',
			bgParallax: true,
			wrapperSpeed: 0.08
		});
	</script>
</body>

</html>