<?php
require_once 'include/common.php';
?>
<!DOCTYPE html>
<html lang="zh-CN">

<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <style>
    body {
      transition: opacity ease-in 0.2s;
    }

    body[unresolved] {
      opacity: 0;
      display: block;
      overflow: hidden;
      position: relative;
    }
  </style>
  <title><?php echo htmlspecialchars($currentSettings['site_name']); ?> - 域名分发系统 智能DNS解析网</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="description" content="<?php echo htmlspecialchars($currentSettings['site_keywords']); ?>">
  <meta name="keywords" content="<?php echo htmlspecialchars($currentSettings['site_keywords']); ?>">
  <link href="./template/concise/assets/pe-icon-7.css" rel="stylesheet" type="text/css">
  <link rel="stylesheet" href="./template/concise/assets/owl.carousel.min.css">
  <link rel="stylesheet" href="./template/concise/assets/owl.theme.default.min.css">
  <link href="./template/concise/assets/bootstrap.min.css" rel="stylesheet" type="text/css">
  <link href="./template/concise/assets/style.min.css" rel="stylesheet" type="text/css">
</head>

<body style="overflow: visible;">

  <!-- Loader -->
  <div id="preloader" style="display: none;">
    <div id="status" style="display: none;">
      <div class="spinner">
        <div class="bounce1"></div>
        <div class="bounce2"></div>
        <div class="bounce3"></div>
      </div>
    </div>
  </div>

  <!-- Navbar Start -->
  <nav class="navbar navbar-expand-lg fixed-top navbar-custom sticky sticky-dark align-items-center">
    <div class="container">
      <!-- LOGO -->
      <a class="logo mr-3" href="#">
        <img src="./assets/images/logo-sm.svg" width="40px" height="40px">
        <?php echo htmlspecialchars($currentSettings['site_name']); ?>
      </a>
      <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarCollapse"
        aria-controls="navbarCollapse" aria-expanded="false" aria-label="Toggle navigation">
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
          stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
          class="feather feather-menu">
          <line x1="3" y1="12" x2="21" y2="12"></line>
          <line x1="3" y1="6" x2="21" y2="6"></line>
          <line x1="3" y1="18" x2="21" y2="18"></line>
        </svg>
      </button>
      <div class="collapse navbar-collapse" id="navbarCollapse">
        <ul class="navbar-nav navbar-center" id="mySidenav">
          <li class="nav-item active">
            <a href="#home" class="nav-link">首页</a>
          </li>
          <li class="nav-item">
            <a href="#about" class="nav-link">关于</a>
          </li>
          <li class="nav-item">
            <a href="#services" class="nav-link">服务</a>
          </li>
          <li class="nav-item">
            <a href="#features" class="nav-link">特色</a>
          </li>
        </ul>

        <ul class="list-inline ml-auto menu-social-icon mb-0 py-2 py-lg-0">
          <li class="list-inline-item ml-0">
            <a href="user/register.php" class="menu-social-link">注册</a>
          </li>
          <li class="list-inline-item ml-0">
            <a href="user" class="menu-social-link">登录</a>
          </li>
        </ul>
      </div>
    </div>
  </nav>
  <!-- Navbar End -->

  <!-- Hero Start -->
  <section class="hero-5-bg position-relative bg-light" id="home">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-lg-6">
          <div class="">
            <h1 class="hero-5-title line-height-1_4 mb-4">实现梦想，从一个 <span class="text-primary">域名开始</span></h1>
            <p class="text-muted mb-4 pb-3">我们将为您提供优质、安全、高品质的服务，让您不在为域名发愁，省心、放心、安心！</p>
            <div class="Subcribe-form">
              <form class="form-inline">
                <a href="user" type="submit" class="btn btn-primary">用户中心</a>
              </form>
            </div>
          </div>
        </div>
        <div class="col-lg-6">
          <img src="./template/concise/assets/hero-5-img.png" alt="" class="hero-5-img">
        </div>
      </div>
    </div>
  </section>
  <!-- Hero End -->

  <!-- About us Start -->
  <section class="section" id="about">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-lg-7">
          <div class="text-center mb-5">
            <h2 class="">关于我们</h2>
            <p class="text-muted">请深刻了解我们提供什么服务，有什么需求.</p>
          </div>
        </div>
      </div>

      <div class="row">
        <div class="col-lg-4">
          <h2 class="font-weight-normal line-height-1_4 mb-4">高效 &amp; 且可为开发人员 <span
              class="font-weight-medium">定制</span></h2>
          <p class="text-muted mb-4">一站式服务，让您为客户提供完美的方案，用心留下客户，是我们力所能及之事.</p>
          <p class="f-17 text-muted"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
              fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
              class="feather feather-grid icon-xs text-primary icon-fill-primary icon mr-2">
              <rect x="3" y="3" width="7" height="7"></rect>
              <rect x="14" y="3" width="7" height="7"></rect>
              <rect x="14" y="14" width="7" height="7"></rect>
              <rect x="3" y="14" width="7" height="7"></rect>
            </svg> 营销计划活动</p>
          <p class="f-17 text-muted"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
              fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
              class="feather feather-layout icon-xs text-primary icon-fill-primary icon mr-2">
              <rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect>
              <line x1="3" y1="9" x2="21" y2="9"></line>
              <line x1="9" y1="21" x2="9" y2="9"></line>
            </svg> 定制产品</p>
          <p class="f-17 text-muted mb-4"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
              viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
              stroke-linejoin="round" class="feather feather-monitor icon-xs text-primary icon-fill-primary icon mr-2">
              <rect x="2" y="3" width="20" height="14" rx="2" ry="2"></rect>
              <line x1="8" y1="21" x2="16" y2="21"></line>
              <line x1="12" y1="17" x2="12" y2="21"></line>
            </svg> 在每时每刻</p>
          <a href="#" class="read-more f-18">More <span class="ml-2 right-icon f-24">→</span></a>
        </div>
        <div class="col-lg-4">
          <div class="card border-0">
            <div class="bg-soft-primary about-img rounded">
              <img src="./template/concise/assets/img-1.png" alt="" class="img-fluid d-block mx-auto">
            </div>
            <div class="mt-3">
              <p class="text-uppercase text-muted mb-2 f-13">预览展示</p>
              <h4 class="f-18">用户中心</h4>
              <p class="text-muted">便捷的操作，让您轻松上云，在线管理域名，让您快人一步，极速响应，让你光彩照人.</p>
              <a href="user/login" class="read-more">More <span class="ml-2 right-icon">→</span></a>
            </div>
          </div>
        </div>
        <div class="col-lg-4">
          <div class="card border-0">
            <div class="bg-soft-info about-img rounded">
              <img src="./template/concise/assets/img-2.png" alt="" class="img-fluid d-block mx-auto">
            </div>
            <div class="mt-3">
              <p class="text-uppercase text-muted mb-2 f-13">预览展示</p>
              <h4 class="f-18">后台管理</h4>
              <p class="text-muted">管理用户，让您一览无余，收入明细，让你时刻舒心，套餐服务，让您管理更快捷，更轻松.</p>
              <a href="#" class="read-more">Read More <span class="ml-2 right-icon">→</span></a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- About us End -->

  <!-- Services Start -->
  <section class="section bg-light" id="services">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-lg-7">
          <div class="text-center mb-5">
            <h2 class="">服务</h2>
            <p class="text-muted">我们将为你提供极致的服务，从此不在担心自己服务不行啦.</p>
          </div>
        </div>
      </div>
      <div class="row">
        <div class="col-lg-4">
          <div class="card service-box text-center p-4">
            <div class="service-icon-bg mx-auto avatar-xxl p-4">
              <div class="service-box-icon justify-content-center">
                <img src="./template/concise/assets/icon-1.png" alt="" class="img-fluid d-block">
              </div>
            </div>
            <h4 class="service-title mt-4 mb-3 f-18">客服服务</h4>
            <p class="service-subtitle mb-4 f-15">快速客服，快速响应，有问必回.</p>
            <a href="#" class="read-more">More<span class="right-icon ml-2">→</span></a>
          </div>
        </div>
        <div class="col-lg-4">
          <div class="card service-box text-center p-4">
            <div class="service-icon-bg mx-auto avatar-xxl p-4">
              <div class="service-box-icon justify-content-center">
                <img src="./template/concise/assets/icon-2.png" alt="" class="img-fluid d-block">
              </div>
            </div>
            <h4 class="service-title mt-4 mb-3 f-18">安全性</h4>
            <p class="service-subtitle mb-4 f-15">企业级的安全，让您不必忧站点安全.</p>
            <a href="#" class="read-more">More<span class="right-icon ml-2">→</span></a>
          </div>
        </div>
        <div class="col-lg-4">
          <div class="card service-box text-center p-4">
            <div class="service-icon-bg mx-auto avatar-xxl p-4">
              <div class="service-box-icon justify-content-center">
                <img src="./template/concise/assets/icon-3.png" alt="" class="img-fluid d-block">
              </div>
            </div>
            <h4 class="service-title mt-4 mb-3 f-18">DNS云解析</h4>
            <p class="service-subtitle mb-4 f-15">专业且易用的智能解析服务.</p>
            <a href="#" class="read-more">More<span class="right-icon ml-2">→</span></a>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- Services End -->

  <!-- Features Start -->
  <section class="section" id="features">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-lg-7">
          <div class="text-center mb-5">
            <h2 class="">特色</h2>
            <p class="text-muted">我们提供三大域名服务商的DNS专业云解析服务.</p>
          </div>
        </div>
      </div>
      <div class="features-content">
        <div class="row align-items-center">
          <div class="col-lg-6 order-2 order-lg-1">
            <div class="tab-content" id="v-pills-tabContent">
              <div class="tab-pane fade show active" id="v-pills-work" role="tabpanel"
                aria-labelledby="v-pills-work-tab">
                <img src="./template/concise/assets/img-11.png" alt="" class="img-fluid d-block mx-auto">
              </div>

              <div class="tab-pane fade" id="v-pills-marketing" role="tabpanel" aria-labelledby="v-pills-marketing-tab">
                <img src="./template/concise/assets/img-21.png" alt="" class="img-fluid d-block mx-auto">
              </div>
              <div class="tab-pane fade" id="v-pills-feedback" role="tabpanel" aria-labelledby="v-pills-feedback-tab">
              </div>
            </div>
          </div>
          <div class="col-lg-5 offset-lg-1 order-1 order-lg-2">
            <div class="nav flex-column nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">
              <a class="nav-link active" id="v-pills-aliyun-tab" data-toggle="pill" href="#v-pills-aliyun" role="tab"
                aria-controls="v-pills-aliyun" aria-selected="true">
                <h4 class="text-dark f-18">阿里云</h4>
                <p class="text-muted f-15">阿里云服务千行百业，为客户创新提速，致力于打造满足严苛要求的云产品.</p>
                <p class="text-primary mb-0 read-more">More <span class="right-icon ml-2">→</span></p>
              </a>
              <a class="nav-link" id="v-pills-txyun-tab" data-toggle="pill" href="#v-pills-txyun" role="tab"
                aria-controls="v-pills-txyun" aria-selected="false">
                <h4 class="text-dark f-18">腾讯云</h4>
                <p class="text-muted f-15">腾讯云提供全面的云计算解决方案，帮助客户提升业务性能和效率.</p>
                <p class="text-primary mb-0 read-more">More <span class="right-icon ml-2">→</span></p>
              </a>
              <a class="nav-link" id="v-pills-dnsla-tab" data-toggle="pill" href="#v-pills-dnsla" role="tab"
                aria-controls="v-pills-dnsla" aria-selected="false">
                <h4 class="text-dark f-18">帝恩爱斯</h4>
                <p class="text-muted f-15">帝恩爱斯专注于域名解析服务，提供稳定可靠的解析解决方案.</p>
                <p class="text-primary mb-0 read-more">More <span class="right-icon ml-2">→</span></p>
              </a>
              <a class="nav-link" id="v-pills-west-tab" data-toggle="pill" href="#v-pills-west" role="tab"
                aria-controls="v-pills-west" aria-selected="false">
                <h4 class="text-dark f-18">西部数码</h4>
                <p class="text-muted f-15">西部数码提供专业的域名注册和解析服务，帮助用户快速部署域名.</p>
                <p class="text-primary mb-0 read-more">More <span class="right-icon ml-2">→</span></p>
              </a>
              <a class="nav-link" id="v-pills-cloudflare-tab" data-toggle="pill" href="#v-pills-cloudflare" role="tab"
                aria-controls="v-pills-cloudflare" aria-selected="false">
                <h4 class="text-dark f-18">Cloudflare</h4>
                <p class="text-muted f-15">Cloudflare 提供全球 CDN 和 DNS 解析服务，确保网站的安全和性能.</p>
                <p class="text-primary mb-0 read-more">More <span class="right-icon ml-2">→</span></p>
              </a>
              <a class="nav-link" id="v-pills-tongxiang-tab" data-toggle="pill" href="#v-pills-tongxiang" role="tab"
                aria-controls="v-pills-tongxiang" aria-selected="false">
                <h4 class="text-dark f-18">同系统</h4>
                <p class="text-muted f-15">同系统提供一站式域名解析服务，确保用户操作简便且高效.</p>
                <p class="text-primary mb-0 read-more">More <span class="right-icon ml-2">→</span></p>
              </a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- Features End -->

  <!-- Footer Start -->
  <section class="footer">
    <div class="container">
      <div class="row">
        <div class="col-lg-12">
          <div class="text-center mt-5">
            <p class="text-white-50 f-15 mb-0">
              Copyright © 2025 <a href=""><?php echo htmlspecialchars($currentSettings['site_name']); ?></a> - All
              rights reserved | 备案号：<a href="#"><?php echo htmlspecialchars($currentSettings['icp']); ?> </a>| Version：<a href="#">1.0</a>
            </p>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- Footer End -->

  <!-- javascript -->
  <script src="./template/concise/assets/jquery.min.js" defer></script>
  <script src="./template/concise/assets/bootstrap.bundle.min.js" defer></script>
  <script src="./template/concise/assets/scrollspy.min.js" defer></script>
  <script src="./template/concise/assets/jquery.easing.min.js" defer></script>
  <script src="./template/concise/assets/feather-icons.js" defer></script>
  <script src="./template/concise/assets/owl.carousel.min.js" defer></script>
  <script src="./template/concise/assets/app.js" defer></script>

  <script>
    // Feather icon
    feather.replace()

    // Testimonial
    $('#testi-clients').owlCarousel({
      loop: true,
      center: true,
      autoplay: true,
      autoplayTimeout: 3000,
      margin: 20,
      nav: true,
      responsive: {
        0: {
          items: 1
        },
        600: {
          items: 2
        },
        1000: {
          items: 3
        }
      }
    })
  </script>

</body>

</html>
