<?php

require_once 'vendor/autoload.php';
use TencentCloud\Common\Credential;
use TencentCloud\Common\Profile\ClientProfile;
use TencentCloud\Common\Profile\HttpProfile;
use TencentCloud\Common\Exception\TencentCloudSDKException;
use TencentCloud\Sms\V20210111\SmsClient;
use TencentCloud\Sms\V20210111\Models\SendSmsRequest;
require_once $_SERVER['DOCUMENT_ROOT'] . '/other/sms/tencentcloud/api_config.php';

function BasicToken($txyunsms_signname, $txyunsms_secretid, $txyunsms_secretkey, $txyunsms_appid, $txyunsms_notice1, $txyunsms_notice2, $txyunsms_notice3, $txyunsms_notice4) {
    return "{$txyunsms_signname},{$txyunsms_secretid},{$txyunsms_secretkey},{$txyunsms_appid},{$txyunsms_notice1},{$txyunsms_notice2},{$txyunsms_notice3},{$txyunsms_notice4}"; 
}

$web_apikey = $apiCredentials['web_apikey'] ?? '';
if (!isset($_GET['apikey']) || $_GET['apikey'] !== $web_apikey) {
    echo json_encode(['code' => 401, 'data' => 'Unauthorized access.']);
    exit;
}

try {
    $cred = new Credential(txyunsms_secretid, txyunsms_secretkey);

    $httpProfile = new HttpProfile();
    $httpProfile->setEndpoint("sms.tencentcloudapi.com");

    $clientProfile = new ClientProfile();
    $clientProfile->setHttpProfile($httpProfile);

    $client = new SmsClient($cred, "ap-beijing", $clientProfile);

    $data = json_decode(file_get_contents("php://input"), true);

    if (isset($data['mobile']) && isset($data['message'])) {
        $req = new SendSmsRequest();

        $messageType = '';
        $code = '';

        if (preg_match('/sendcode(\d+)/', $data['message'], $matches)) {
            $messageType = 'sendcode';
            $code = $matches[1];
        } else {
            $messageType = $data['message'];
        }

        switch ($messageType) {
            case 'newticket':
                $templateId = txyunsms_notice1;
                break;
            case 'userreply':
                $templateId = txyunsms_notice3;
                break;
            case 'adminreply':
                $templateId = txyunsms_notice2;
                break;
            case 'sendcode':
                $templateId = txyunsms_notice4;
                break;
            default:
                error_log("未知的消息内容: " . $data['message']);
                echo json_encode(['code' => 400, 'data' => '未知的消息内容']);
                return;
        }

        $params = array(
            "PhoneNumberSet" => array($data['mobile']),
            "SmsSdkAppId" => txyunsms_appid,
            "TemplateId" => $templateId,
            "SignName" => txyunsms_signname,
            "TemplateParamSet" => $messageType === 'sendcode' ? array($code) : array()
        );

        $req->fromJsonString(json_encode($params));

        $resp = $client->SendSms($req);

        $responseArray = json_decode($resp->toJsonString(), true);
        if (isset($responseArray['SendStatusSet']) && is_array($responseArray['SendStatusSet'])) {
            foreach ($responseArray['SendStatusSet'] as $status) {
                if (isset($status['Code']) && $status['Code'] === 'Ok') {
                    echo json_encode(['code' => 200, 'data' => '短信发送成功']);
                    return;
                }
            }
        }

        echo json_encode(['code' => 500, 'data' => '短信发送失败']);
    } else {
        error_log("缺少必需的参数。");
        echo json_encode(['code' => 400, 'data' => '缺少必需的参数']);
    }

} catch (TencentCloudSDKException $e) {
    echo json_encode(['code' => 500, 'data' => '发送短信时发生错误: ' . $e->getMessage()]);
}

