<?php

// This file is auto-generated, don't edit it. Thanks.

namespace AlibabaCloud\SDK\Dysmsapi\V20170525\Models;

use AlibabaCloud\SDK\Dysmsapi\V20170525\Models\GetSmsTemplateResponseBody\auditInfo;
use AlibabaCloud\SDK\Dysmsapi\V20170525\Models\GetSmsTemplateResponseBody\fileUrlList;
use AlibabaCloud\SDK\Dysmsapi\V20170525\Models\GetSmsTemplateResponseBody\moreDataFileUrlList;
use AlibabaCloud\Tea\Model;

class GetSmsTemplateResponseBody extends Model
{
    /**
     * @description Application scenario content.
     *
     * @example http://www.aliyun.com/
     *
     * @var string
     */
    public $applyScene;

    /**
     * @description Audit information.
     *
     * @var auditInfo
     */
    public $auditInfo;

    /**
     * @description Request status code.
     *
     * OK indicates a successful request.
     * For other error codes, please refer to [API Error Codes](https://help.aliyun.com/document_detail/101346.html).
     *
     * @example OK
     *
     * @var string
     */
    public $code;

    /**
     * @description The time when the SMS template was created.
     *
     * @example 2024-06-03 10:02:34
     *
     * @var string
     */
    public $createDate;

    /**
     * @description File information, compatible with signatures created by the [AddSmsSign](https://help.aliyun.com/zh/sms/developer-reference/api-dysmsapi-2017-05-25-addsmstemplate?spm) API.
     *
     * @var fileUrlList
     */
    public $fileUrlList;

    /**
     * @description International/Hong Kong, Macao, and Taiwan template type. When the **TemplateType** parameter is **3**, this parameter is required for international/Hong Kong, Macao, and Taiwan templates, with values:
     * - **0**: Verification code.
     * - **1**: SMS notification.
     * - **2**: Promotional SMS.
     * @example 0
     *
     * @var int
     */
    public $intlType;

    /**
     * @description Description of the status code.
     *
     * @example OK
     *
     * @var string
     */
    public $message;

    /**
     * @description Additional documentation information, supplementing uploaded business proof files or operational screenshots file list.
     *
     * @var moreDataFileUrlList
     */
    public $moreDataFileUrlList;

    /**
     * @description Work order number.
     *
     * This parameter is used by auditors when querying the audit. You need to provide this work order number when requesting expedited review.
     * @example 2003019****
     *
     * @var string
     */
    public $orderId;

    /**
     * @description The SMS signature associated with the template when applied.
     *
     * @example 阿里云
     *
     * @var string
     */
    public $relatedSignName;

    /**
     * @description Explanation for the SMS template application, which is one of the reference information for template review.
     *
     * @example 申请验证码模板
     *
     * @var string
     */
    public $remark;

    /**
     * @description The ID of this call request, which is a unique identifier generated by Alibaba Cloud for the request and can be used for troubleshooting and issue定位.
     *
     * @example 819BE656-D2E0-4858-8B21-B2E47708****
     *
     * @var string
     */
    public $requestId;

    /**
     * @description SMS template code.
     *
     * @example SMS_20375****
     *
     * @var string
     */
    public $templateCode;

    /**
     * @description Content of the SMS template.
     *
     * @example 您正在申请手机注册，验证码为：${code}，5分钟内有效！
     *
     * @var string
     */
    public $templateContent;

    /**
     * @description Name of the SMS template.
     *
     * @example 验证码
     *
     * @var string
     */
    public $templateName;

    /**
     * @description Template review status. Return values:
     *
     * - **0**: Under review.
     * - **1**: Approved.
     * - **2**: Not approved, with reasons for failure returned. Please refer to [Handling Suggestions for Failed SMS Reviews](https://help.aliyun.com/zh/sms/user-guide/causes-of-application-failures-and-suggestions?spm=a2c4g.11186623.0.0.41fd339f3bPSCQ), invoke the [UpdateSmsTemplate](https://help.aliyun.com/zh/sms/developer-reference/api-dysmsapi-2017-05-25-updatesmstemplate?spm) API or modify the SMS template on the [Template Management](https://dysms.console.aliyun.com/domestic/text/template) page.
     * - **10**: Review canceled.
     * @example 2
     *
     * @var string
     */
    public $templateStatus;

    /**
     * @description Template identifier, indicating whether the template is user-defined or system-provided. Values:
     *
     * - **2**: User-defined template.
     *
     * - **3**: System-provided template.
     * @example 2
     *
     * @var int
     */
    public $templateTag;

    /**
     * @description SMS type. Values:
     *
     * - **0**: Verification code.
     * - **1**: SMS notification.
     * - **2**: Promotional SMS.
     * - **3**: International/Hong Kong, Macao, and Taiwan messages.
     *
     * > Only enterprise-certified users can apply for promotional SMS and international/Hong Kong, Macao, and Taiwan messages. For details on the differences between personal and enterprise user rights, please refer to [Usage Notes](https://help.aliyun.com/zh/sms/user-guide/usage-notes?spm=a2c4g.11186623.0.0.67447f576NJnE8).
     * @example 0
     *
     * @var string
     */
    public $templateType;

    /**
     * @description Template variable rules.
     *
     * For detailed rules of template variables, refer to the [Example Document](https://help.aliyun.com/zh/sms/templaterule-template-variable-parameter-filling-example).
     * @example {"code":"characterWithNumber"}
     *
     * @var string
     */
    public $variableAttribute;
    protected $_name = [
        'applyScene'          => 'ApplyScene',
        'auditInfo'           => 'AuditInfo',
        'code'                => 'Code',
        'createDate'          => 'CreateDate',
        'fileUrlList'         => 'FileUrlList',
        'intlType'            => 'IntlType',
        'message'             => 'Message',
        'moreDataFileUrlList' => 'MoreDataFileUrlList',
        'orderId'             => 'OrderId',
        'relatedSignName'     => 'RelatedSignName',
        'remark'              => 'Remark',
        'requestId'           => 'RequestId',
        'templateCode'        => 'TemplateCode',
        'templateContent'     => 'TemplateContent',
        'templateName'        => 'TemplateName',
        'templateStatus'      => 'TemplateStatus',
        'templateTag'         => 'TemplateTag',
        'templateType'        => 'TemplateType',
        'variableAttribute'   => 'VariableAttribute',
    ];

    public function validate()
    {
    }

    public function toMap()
    {
        $res = [];
        if (null !== $this->applyScene) {
            $res['ApplyScene'] = $this->applyScene;
        }
        if (null !== $this->auditInfo) {
            $res['AuditInfo'] = null !== $this->auditInfo ? $this->auditInfo->toMap() : null;
        }
        if (null !== $this->code) {
            $res['Code'] = $this->code;
        }
        if (null !== $this->createDate) {
            $res['CreateDate'] = $this->createDate;
        }
        if (null !== $this->fileUrlList) {
            $res['FileUrlList'] = null !== $this->fileUrlList ? $this->fileUrlList->toMap() : null;
        }
        if (null !== $this->intlType) {
            $res['IntlType'] = $this->intlType;
        }
        if (null !== $this->message) {
            $res['Message'] = $this->message;
        }
        if (null !== $this->moreDataFileUrlList) {
            $res['MoreDataFileUrlList'] = null !== $this->moreDataFileUrlList ? $this->moreDataFileUrlList->toMap() : null;
        }
        if (null !== $this->orderId) {
            $res['OrderId'] = $this->orderId;
        }
        if (null !== $this->relatedSignName) {
            $res['RelatedSignName'] = $this->relatedSignName;
        }
        if (null !== $this->remark) {
            $res['Remark'] = $this->remark;
        }
        if (null !== $this->requestId) {
            $res['RequestId'] = $this->requestId;
        }
        if (null !== $this->templateCode) {
            $res['TemplateCode'] = $this->templateCode;
        }
        if (null !== $this->templateContent) {
            $res['TemplateContent'] = $this->templateContent;
        }
        if (null !== $this->templateName) {
            $res['TemplateName'] = $this->templateName;
        }
        if (null !== $this->templateStatus) {
            $res['TemplateStatus'] = $this->templateStatus;
        }
        if (null !== $this->templateTag) {
            $res['TemplateTag'] = $this->templateTag;
        }
        if (null !== $this->templateType) {
            $res['TemplateType'] = $this->templateType;
        }
        if (null !== $this->variableAttribute) {
            $res['VariableAttribute'] = $this->variableAttribute;
        }

        return $res;
    }

    /**
     * @param array $map
     *
     * @return GetSmsTemplateResponseBody
     */
    public static function fromMap($map = [])
    {
        $model = new self();
        if (isset($map['ApplyScene'])) {
            $model->applyScene = $map['ApplyScene'];
        }
        if (isset($map['AuditInfo'])) {
            $model->auditInfo = auditInfo::fromMap($map['AuditInfo']);
        }
        if (isset($map['Code'])) {
            $model->code = $map['Code'];
        }
        if (isset($map['CreateDate'])) {
            $model->createDate = $map['CreateDate'];
        }
        if (isset($map['FileUrlList'])) {
            $model->fileUrlList = fileUrlList::fromMap($map['FileUrlList']);
        }
        if (isset($map['IntlType'])) {
            $model->intlType = $map['IntlType'];
        }
        if (isset($map['Message'])) {
            $model->message = $map['Message'];
        }
        if (isset($map['MoreDataFileUrlList'])) {
            $model->moreDataFileUrlList = moreDataFileUrlList::fromMap($map['MoreDataFileUrlList']);
        }
        if (isset($map['OrderId'])) {
            $model->orderId = $map['OrderId'];
        }
        if (isset($map['RelatedSignName'])) {
            $model->relatedSignName = $map['RelatedSignName'];
        }
        if (isset($map['Remark'])) {
            $model->remark = $map['Remark'];
        }
        if (isset($map['RequestId'])) {
            $model->requestId = $map['RequestId'];
        }
        if (isset($map['TemplateCode'])) {
            $model->templateCode = $map['TemplateCode'];
        }
        if (isset($map['TemplateContent'])) {
            $model->templateContent = $map['TemplateContent'];
        }
        if (isset($map['TemplateName'])) {
            $model->templateName = $map['TemplateName'];
        }
        if (isset($map['TemplateStatus'])) {
            $model->templateStatus = $map['TemplateStatus'];
        }
        if (isset($map['TemplateTag'])) {
            $model->templateTag = $map['TemplateTag'];
        }
        if (isset($map['TemplateType'])) {
            $model->templateType = $map['TemplateType'];
        }
        if (isset($map['VariableAttribute'])) {
            $model->variableAttribute = $map['VariableAttribute'];
        }

        return $model;
    }
}
