<?php

// This file is auto-generated, don't edit it. Thanks.

namespace AlibabaCloud\SDK\Dysmsapi\V20170525\Models;

use AlibabaCloud\SDK\Dysmsapi\V20170525\Models\GetSmsSignResponseBody\auditInfo;
use AlibabaCloud\Tea\Model;

class GetSmsSignResponseBody extends Model
{
    /**
     * @description Content of application scenarios.
     *
     * @example http://www.aliyun.com/
     *
     * @var string
     */
    public $applyScene;

    /**
     * @description Audit information.
     *
     * @var auditInfo
     */
    public $auditInfo;

    /**
     * @description Request status code.
     *
     * - For other error codes, see [API Error Codes](https://help.aliyun.com/document_detail/101346.html).
     * @example OK
     *
     * @var string
     */
    public $code;

    /**
     * @description Creation date and time of the SMS signature.
     *
     * @example 2024-06-03 10:02:34
     *
     * @var string
     */
    public $createDate;

    /**
     * @description 更多资料信息，补充上传业务证明文件或业务截图文件列表。
     *
     * @var string[]
     */
    public $fileUrlList;

    /**
     * @description Description of the status code.
     *
     * @example OK
     *
     * @var string
     */
    public $message;

    /**
     * @description Work order number.
     *
     * Used by reviewers when querying the review. You need to provide this work order number if you require expedited review.
     * @example 20044156924
     *
     * @var string
     */
    public $orderId;

    /**
     * @description Credential ID, the credential ID associated when applying for the signature.
     *
     * @example 2004393****
     *
     * @var int
     */
    public $qualificationId;

    /**
     * @description Explanation of the SMS signature scenario, with a maximum length of 200 characters.
     *
     * @example Send verification code text message during login.
     *
     * @var string
     */
    public $remark;

    /**
     * @description The ID of this call request, which is a unique identifier generated by Alibaba Cloud for the request and can be used for troubleshooting and issue localization.
     *
     * @example F655A8D5-B967-440B-8683-DAD6FF8DE990
     *
     * @var string
     */
    public $requestId;

    /**
     * @description SMS signature code.
     *
     * @example SIGN_100000077042023_17174665*****_ZM2kG
     *
     * @var string
     */
    public $signCode;

    /**
     * @description SMS signature name.
     *
     * @example Aliyun
     *
     * @var string
     */
    public $signName;

    /**
     * @description Signature review status. Values:
     *
     * - **0**: Under review.
     * - **1**: Approved.
     * - **2**: Review failed, please check the Reason parameter for the failure cause.
     * - **10**: Review canceled.
     * @example 2
     *
     * @var int
     */
    public $signStatus;

    /**
     * @description Signature tag indicating whether the signature is user-defined, system-provided, test, or trial. Values:
     *
     * - 5: Trial signature
     * @example 2
     *
     * @var string
     */
    public $signTag;

    /**
     * @description scenarios for using signatures.
     *
     * @example App.
     *
     * @var string
     */
    public $signUsage;

    /**
     * @description Signature usage indication—self-use or third-party use.
     *
     * - true: Third-party use
     * @example false
     *
     * @var bool
     */
    public $thirdParty;
    protected $_name = [
        'applyScene'      => 'ApplyScene',
        'auditInfo'       => 'AuditInfo',
        'code'            => 'Code',
        'createDate'      => 'CreateDate',
        'fileUrlList'     => 'FileUrlList',
        'message'         => 'Message',
        'orderId'         => 'OrderId',
        'qualificationId' => 'QualificationId',
        'remark'          => 'Remark',
        'requestId'       => 'RequestId',
        'signCode'        => 'SignCode',
        'signName'        => 'SignName',
        'signStatus'      => 'SignStatus',
        'signTag'         => 'SignTag',
        'signUsage'       => 'SignUsage',
        'thirdParty'      => 'ThirdParty',
    ];

    public function validate()
    {
    }

    public function toMap()
    {
        $res = [];
        if (null !== $this->applyScene) {
            $res['ApplyScene'] = $this->applyScene;
        }
        if (null !== $this->auditInfo) {
            $res['AuditInfo'] = null !== $this->auditInfo ? $this->auditInfo->toMap() : null;
        }
        if (null !== $this->code) {
            $res['Code'] = $this->code;
        }
        if (null !== $this->createDate) {
            $res['CreateDate'] = $this->createDate;
        }
        if (null !== $this->fileUrlList) {
            $res['FileUrlList'] = $this->fileUrlList;
        }
        if (null !== $this->message) {
            $res['Message'] = $this->message;
        }
        if (null !== $this->orderId) {
            $res['OrderId'] = $this->orderId;
        }
        if (null !== $this->qualificationId) {
            $res['QualificationId'] = $this->qualificationId;
        }
        if (null !== $this->remark) {
            $res['Remark'] = $this->remark;
        }
        if (null !== $this->requestId) {
            $res['RequestId'] = $this->requestId;
        }
        if (null !== $this->signCode) {
            $res['SignCode'] = $this->signCode;
        }
        if (null !== $this->signName) {
            $res['SignName'] = $this->signName;
        }
        if (null !== $this->signStatus) {
            $res['SignStatus'] = $this->signStatus;
        }
        if (null !== $this->signTag) {
            $res['SignTag'] = $this->signTag;
        }
        if (null !== $this->signUsage) {
            $res['SignUsage'] = $this->signUsage;
        }
        if (null !== $this->thirdParty) {
            $res['ThirdParty'] = $this->thirdParty;
        }

        return $res;
    }

    /**
     * @param array $map
     *
     * @return GetSmsSignResponseBody
     */
    public static function fromMap($map = [])
    {
        $model = new self();
        if (isset($map['ApplyScene'])) {
            $model->applyScene = $map['ApplyScene'];
        }
        if (isset($map['AuditInfo'])) {
            $model->auditInfo = auditInfo::fromMap($map['AuditInfo']);
        }
        if (isset($map['Code'])) {
            $model->code = $map['Code'];
        }
        if (isset($map['CreateDate'])) {
            $model->createDate = $map['CreateDate'];
        }
        if (isset($map['FileUrlList'])) {
            if (!empty($map['FileUrlList'])) {
                $model->fileUrlList = $map['FileUrlList'];
            }
        }
        if (isset($map['Message'])) {
            $model->message = $map['Message'];
        }
        if (isset($map['OrderId'])) {
            $model->orderId = $map['OrderId'];
        }
        if (isset($map['QualificationId'])) {
            $model->qualificationId = $map['QualificationId'];
        }
        if (isset($map['Remark'])) {
            $model->remark = $map['Remark'];
        }
        if (isset($map['RequestId'])) {
            $model->requestId = $map['RequestId'];
        }
        if (isset($map['SignCode'])) {
            $model->signCode = $map['SignCode'];
        }
        if (isset($map['SignName'])) {
            $model->signName = $map['SignName'];
        }
        if (isset($map['SignStatus'])) {
            $model->signStatus = $map['SignStatus'];
        }
        if (isset($map['SignTag'])) {
            $model->signTag = $map['SignTag'];
        }
        if (isset($map['SignUsage'])) {
            $model->signUsage = $map['SignUsage'];
        }
        if (isset($map['ThirdParty'])) {
            $model->thirdParty = $map['ThirdParty'];
        }

        return $model;
    }
}
