<?php

require_once 'vendor/autoload.php';
use TencentCloud\Common\Credential;
use TencentCloud\Common\Profile\ClientProfile;
use TencentCloud\Common\Profile\HttpProfile;
use TencentCloud\Common\Exception\TencentCloudSDKException;
use TencentCloud\Faceid\V20180301\FaceidClient;
use TencentCloud\Faceid\V20180301\Models\PhoneVerificationRequest;
require '../include/common.php'; 
$secretid = $apiCredentials['secretid'];
$secretkey = $apiCredentials['secretkey'];
$apikey = $apiCredentials['web_apikey'];
// 检查请求是否包含密钥
if (!isset($_GET['apikey']) || $_GET['apikey'] !== $apiKey) {
    echo json_encode(['error' => true, 'message' => 'Unauthorized access.']);
    exit; // 如果密钥不匹配，则退出
}

try {
    // 实例化一个认证对象，入参需要传入腾讯云账户 SecretId 和 SecretKey
    $cred = new Credential($secretid , $secretkey);

    // 实例化一个http选项
    $httpProfile = new HttpProfile();
    $httpProfile->setEndpoint("faceid.tencentcloudapi.com");

    // 实例化一个client选项
    $clientProfile = new ClientProfile();
    $clientProfile->setHttpProfile($httpProfile);
    
    // 实例化要请求产品的client对象
    $client = new FaceidClient($cred, "", $clientProfile);

    // 实例化一个请求对象
    $req = new PhoneVerificationRequest();

    // 从 POST 请求中获取参数
    $params = json_decode(file_get_contents('php://input'), true);

    // 检查必要的参数是否存在
    if (!isset($params['IdCard']) || !isset($params['Name']) || !isset($params['Phone'])) {
        echo json_encode(['error' => 'Missing parameters: IdCard, Name, Phone are required.']);
        exit();
    }

    // 设置请求参数
    $req->fromJsonString(json_encode($params));

    // 返回的resp是一个PhoneVerificationResponse的实例，与请求对象对应
    $resp = $client->PhoneVerification($req);

    // 输出json格式的字符串回包
    header('Content-Type: application/json');
    echo $resp->toJsonString();
}
catch(TencentCloudSDKException $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
?>
