<?php
require '../vendor/autoload.php'; // 引入 Composer 自动加载

use AlibabaCloud\SDK\Cloudauth\V20190307\Cloudauth;
use AlibabaCloud\Tea\Utils\Utils;
use AlibabaCloud\Tea\Console\Console;
use AlibabaCloud\Tea\Exception\TeaError;
use Darabonba\OpenApi\Models\Config;
use AlibabaCloud\SDK\Cloudauth\V20190307\Models\Mobile3MetaDetailVerifyRequest;
use AlibabaCloud\Tea\Utils\Utils\RuntimeOptions;
require_once $_SERVER['DOCUMENT_ROOT'] .'/other/realname/aliyun/api_config.php'
// 创建阿里云客户端
class Index { 
    /**
     * 
     * @return Cloudauth Client
     */
    // 生成 Basic 认证令牌
function BasicToken($accessKeyId, $accessKeySecret,$web_apikey) {
    return "{$accessKeyId},{$accessKeySecret},{$web_apikey}"; 
}
// 定义密钥
$apiKey = web_apikey; 

// 检查请求是否包含密钥
if (!isset($_GET['apikey']) || $_GET['apikey'] !== $apiKey) {
    echo json_encode(['error' => true, 'message' => 'Unauthorized access.']);
    exit; // 如果密钥不匹配，则退出
}

    public static function createClient() {
        // 替换为您的 AK ID 和 SK
        $config = new Config([
            "accessKeyId" => accessKeyId,
            "accessKeySecret" => accessKeySecret,
        ]);
        $config->endpoint = "cloudauth.aliyuncs.com";
        return new Cloudauth($config);
    }

    /**
     * 主函数
     * @param array $params
     * @return void
     */
    public static function main($params) {
        $client = self::createClient();

        // 检查参数
        if (!isset($params['IdCard'], $params['Name'], $params['Phone'])) {
            echo json_encode(["error" => "缺少必要的参数：IdCard, Name, Phone 是必须的。"]);
            exit();
        }

        $mobile3MetaDetailVerifyRequest = new Mobile3MetaDetailVerifyRequest([
            "paramType" => "normal",
            "identifyNum" => $params['IdCard'],
            "userName" => $params['Name'],
            "mobile" => $params['Phone']
        ]);

        $runtime = new RuntimeOptions([]);
        try {
            $resp = $client->mobile3MetaDetailVerifyWithOptions($mobile3MetaDetailVerifyRequest, $runtime);
            Console::log(Utils::toJSONString($resp));
            // 假设 $resp->body 结构如下，并且包含所需的字段
            $bodyData = isset($resp->body) ? $resp->body : null;

            if ($bodyData) {
                // 重新构造为所需的格式
                $formattedResponse = [
                    "Response" => [
                        "Result" => ($bodyData->code === "200") ? "0" : "1", // 如果 code 为 200，Result 为 0，否则为 1
                        "Description" => $bodyData->message ?? "认证通过", // 根据实际字段调整
                        "Isp" => $bodyData->resultObject->ispName ?? "", // 根据实际字段调整
                        "RequestId" => $bodyData->requestId ?? null // 根据实际字段调整
                    ]
                ];

                echo json_encode($formattedResponse); // 返回格式化后的数据
            } else {
                // 如果没有数据，则返回一个空或错误的格式
                echo json_encode(["Response" => null]);
            }

        } catch (Exception $error) {
            if (!($error instanceof TeaError)) {
                $error = new TeaError([], $error->getMessage(), $error->getCode(), $error);
            }
            // 错误处理
            echo json_encode([
                "error" => $error->message,
                "recommend" => $error->data["Recommend"] ?? null
            ]);
        }
    }
}

// 处理 POST 请求
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $params = json_decode(file_get_contents('php://input'), true); // 获取 JSON 格式的输入数据
    Index::main($params); // 调用主函数并传入参数
} else {
    echo json_encode(["error" => "请使用 POST 请求提交数据。"]);
}
