<?php
session_name('admin_session');
session_start();
include('../include/common.php');
$title = '检查版本更新';
if (!isset($_SESSION['role'])) {
    header("Location: login.php");
    exit();
}

function zipExtract($src, $dest)
{
    $zip = new ZipArchive();
    if ($zip->open($src) === true) {
        $zip->extractTo($dest);
        $zip->close();
        return true;
    }
    return false;
}
// 删除目录下所有文件封装函数
function deldir($dir)
{
    if (!is_dir($dir))
        return false;
    $dh = opendir($dir);
    while ($file = readdir($dh)) {
        if ($file != "." && $file != "..") {
            $fullpath = $dir . "/" . $file;
            if (!is_dir($fullpath)) {
                unlink($fullpath);
            } else {
                deldir($fullpath);
            }
        }
    }
    closedir($dh);
    if (rmdir($dir)) {
        return true;
    } else {
        return false;
    }
}

include 'header.php';
?>
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="col-xs-12 center-block" style="float: none;">
                <div class="block">
                    <div class="block-title">
                        <h3 class="panel-title">检查更新</h3>
                    </div>
                    <div class="panel-body">
                        <div id="msg" class="alert alert-info"><i class="fa fa-spinner fa-spin"></i>正在检测中</div>
                        <hr />
                        <div id="update_log" class="well" style="display:none"></div>
                        <a id="update_btn" class="btn btn-primary btn-block" style="display:none">立即更新</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="//cdn.staticfile.org/jquery/1.12.4/jquery.min.js"></script>
<script src="//cdn.staticfile.org/layer/2.3/layer.js"></script>
<script>
    $(function () {
        var i = layer.load(0);
        $.ajax({
            type: 'POST',
            url: 'update.php',
            data: { 'SF_Action': 'check' },
            dataType: 'json',
            success: function (data) {
                layer.close(i);
                if (data.code == 0) {
                    if (data.data.data.code == 1) {
                        var update_log = '更新内容<hr/>';
                        $.each(data.data.data.data.update_log, function (index, value) {
                            if (typeof value !== 'string') {
                                value = String(value);
                            }
                            value = value.replace(/,/g, '<br/>');
                            update_log += value + '<br/><br/>';
                        });
                        $("#update_log").html(update_log);
                        $("#update_btn").css('display', 'inherit');
                        $("#update_log").css('display', 'inherit');
                        $("#msg").addClass('alert-primary');
                        $("#msg").html('当前最新版 V' + data.data.data.data.edition);
                    } else {
                        $("#msg").addClass('alert-success');
                        $("#msg").html('您当前已是最新版本');
                    }
                } else {
                    // 错误信息
                    $("#msg").addClass('alert-danger');
                    $("#msg").html(data.msg);
                }

            },
            error: function () {
                layer.close(i);
                $("#msg").html('服务器错误！');
                setTimeout(function () {
                    window.location.reload();
                }, 10);
            }

        });

        function update() {
            var i = layer.load(0);
            $.ajax({
                type: 'POST',
                url: 'update.php',
                data: { 'SF_Action': 'update' },
                dataType: "json",
                success: function (data) {
                    layer.close(i);
                    if (data.code == 1) {
                        layer.msg(data.msg, { icon: 1 });
                    } else if (data.code == 0) {
                        layer.msg(data.msg, { icon: 1 });
                        setTimeout(function () {
                            update();
                        }, 1000);
                    } else {
                        layer.msg(data.msg, { icon: 2 });
                    }

                },
                error: function () {
                    layer.close(i);
                    $("#msg").html('服务器错误！');
                }
            });
        }
        $("#update_btn").click(function () {
            update();
        });
    });
</script>