<?php
session_name('admin_session');
session_start();
require './ajax.php';
require_once '../include/common.php';
// 检查用户是否已登录
if (!isset($_SESSION['role'])) {
    header("Location: login.php");
    exit();
}
?>

<?php include 'header.php'; ?>
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0 font-size-18">控制台</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);"><?php echo $currentSettings['site_name'] ?></a></li>
                                <li class="breadcrumb-item active">首页</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-xl-3 col-md-6">
                    <div class="card card-h-100">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-6">
                                    <span class="text-muted mb-3 lh-1 d-block text-truncate">今日注册用户</span>
                                    <h4 class="mb-3">
                                        <span class="counter-value"
                                            data-target="865.2"><?php echo $new_user_count; ?></span>
                                    </h4>
                                </div>
                                <div class="col-6">
                                    <div id="mini-chart1" data-colors='["#5156be"]' class="apex-charts mb-2"></div>
                                </div>
                            </div>
                            <div class="text-nowrap">
                                <span
                                    class="badge bg-<?php echo ($user_diff_percent >= 0 ? 'success' : 'danger'); ?>-subtle text-<?php echo ($user_diff_percent >= 0 ? 'success' : 'danger'); ?>">
                                    <?php echo ($user_diff_percent >= 0 ? '+' : '') . $user_diff_percent; ?>%
                                </span>
                                <span class="ms-1 text-muted font-size-13">对比昨日</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6">
                    <div class="card card-h-100">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-6">
                                    <span class="text-muted mb-3 lh-1 d-block text-truncate">今日新增解析</span>
                                    <h4 class="mb-3">
                                        <span class="counter-value"
                                            data-target="12.57"><?php echo $dns_total_count ?? 0; ?></span>
                                    </h4>
                                </div>
                                <div class="col-6">
                                    <div id="mini-chart4" data-colors='["#5156be"]' class="apex-charts mb-2"></div>
                                </div>
                            </div>
                            <div class="text-nowrap">
                                <span
                                    class="badge bg-<?php echo ($dns_diff_percent >= 0 ? 'success' : 'danger'); ?>-subtle text-<?php echo ($dns_diff_percent >= 0 ? 'success' : 'danger'); ?>">
                                    <?php echo ($dns_diff_percent >= 0 ? '+' : '') . $dns_diff_percent; ?>%
                                </span>
                                <span class="ms-1 text-muted font-size-13">对比前日</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6">
                    <div class="card card-h-100">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-6">
                                    <span class="text-muted mb-3 lh-1 d-block text-truncate">今日充值金额</span>
                                    <h4 class="mb-3">
                                        <span class="counter-value"
                                            data-target="6258">￥<?php echo $recharge_amount ?? 0; ?></span>
                                    </h4>
                                </div>
                                <div class="col-6">
                                    <div id="mini-chart2" data-colors='["#5156be"]' class="apex-charts mb-2"></div>
                                </div>
                            </div>
                            <div class="text-nowrap">
                                <span
                                    class="badge bg-<?php echo ($recharge_diff_percent >= 0 ? 'success' : 'danger'); ?>-subtle text-<?php echo ($recharge_diff_percent >= 0 ? 'success' : 'danger'); ?>">
                                    <?php echo ($recharge_diff_percent >= 0 ? '+' : '') . $recharge_diff_percent; ?>%
                                </span>
                                <span class="ms-1 text-muted font-size-13">对比前日</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6">
                    <div class="card card-h-100">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-6">
                                    <span class="text-muted mb-3 lh-1 d-block text-truncate">今日订单数量</span>
                                    <h4 class="mb-3">
                                        <span class="counter-value"
                                            data-target="4.32"><?php echo $order_today_count ?? 0; ?></span>
                                    </h4>
                                </div>
                                <div class="col-6">
                                    <div id="mini-chart3" data-colors='["#5156be"]' class="apex-charts mb-2"></div>
                                </div>
                            </div>
                            <div class="text-nowrap">
                                <span
                                    class="badge bg-<?php echo ($order_diff_percent >= 0 ? 'success' : 'danger'); ?>-subtle text-<?php echo ($order_diff_percent >= 0 ? 'success' : 'danger'); ?>">
                                    <?php echo ($order_diff_percent >= 0 ? '+' : '') . $order_diff_percent; ?>%
                                </span>
                                <span class="ms-1 text-muted font-size-13">对比昨日</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-xl-3 col-md-6">
                    <div class="card card-h-100">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-6">
                                    <span class="text-muted mb-3 lh-1 d-block text-truncate">全站用户数量</span>
                                    <h4 class="mb-3">
                                        <span class="counter-value"
                                            data-target="865.2"><?php echo htmlspecialchars($users_count); ?></span>
                                    </h4>
                                </div>
                                <div class="col-6">
                                    <div id="mini-chart1" data-colors='["#5156be"]' class="apex-charts mb-2"></div>
                                </div>
                            </div>
                            <div class="text-nowrap">
                                <span
                                    class="badge bg-<?php echo ($user_diff_percent >= 0 ? 'success' : 'danger'); ?>-subtle text-<?php echo ($user_diff_percent >= 0 ? 'success' : 'danger'); ?>">
                                    <?php echo ($user_diff_percent >= 0 ? '+' : '') . $user_diff_percent; ?>%
                                </span>
                                <span class="ms-1 text-muted font-size-13">对比昨日</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6">
                    <div class="card card-h-100">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-6">
                                    <span class="text-muted mb-3 lh-1 d-block text-truncate">全站解析数量</span>
                                    <h4 class="mb-3">
                                        <span class="counter-value"
                                            data-target="6258"><?php echo htmlspecialchars($dns_count); ?></span>
                                    </h4>
                                </div>
                                <div class="col-6">
                                    <div id="mini-chart2" data-colors='["#5156be"]' class="apex-charts mb-2"></div>
                                </div>
                            </div>
                            <div class="text-nowrap">
                                <span
                                    class="badge bg-<?php echo ($dns_diff_percent >= 0 ? 'success' : 'danger'); ?>-subtle text-<?php echo ($dns_diff_percent >= 0 ? 'success' : 'danger'); ?>">
                                    <?php echo ($dns_diff_percent >= 0 ? '+' : '') . $dns_diff_percent; ?>%
                                </span>
                                <span class="ms-1 text-muted font-size-13">对比前日</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6">
                    <div class="card card-h-100">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-6">
                                    <span class="text-muted mb-3 lh-1 d-block text-truncate">全站充值总额</span>
                                    <h4 class="mb-3">
                                        ￥<span class="counter-value"
                                            data-target="4.32"><?php echo $amount_sum?? 0; ?></span>
                                    </h4>
                                </div>
                                <div class="col-6">
                                    <div id="mini-chart3" data-colors='["#5156be"]' class="apex-charts mb-2"></div>
                                </div>
                            </div>
                            <div class="text-nowrap">
                                <span
                                    class="badge bg-<?php echo ($recharge_diff_percent >= 0 ? 'success' : 'danger'); ?>-subtle text-<?php echo ($recharge_diff_percent >= 0 ? 'success' : 'danger'); ?>">
                                    <?php echo ($recharge_diff_percent >= 0 ? '+' : '') . $recharge_diff_percent; ?>%
                                </span>
                                <span class="ms-1 text-muted font-size-13">对比昨日</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6">
                    <div class="card card-h-100">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-6">
                                    <span class="text-muted mb-3 lh-1 d-block text-truncate">全站订单总数</span>
                                    <h4 class="mb-3">
                                        <span class="counter-value"
                                            data-target="12.57"><?php echo htmlspecialchars($order_count); ?></span>
                                    </h4>
                                </div>
                                <div class="col-6">
                                    <div id="mini-chart4" data-colors='["#5156be"]' class="apex-charts mb-2"></div>
                                </div>
                            </div>
                            <div class="text-nowrap">
                                <span
                                    class="badge bg-<?php echo ($order_diff_percent >= 0 ? 'success' : 'danger'); ?>-subtle text-<?php echo ($order_diff_percent >= 0 ? 'success' : 'danger'); ?>">
                                    <?php echo ($order_diff_percent >= 0 ? '+' : '') . $order_diff_percent; ?>%
                                </span>
                                <span class="ms-1 text-muted font-size-13">对比前日</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>

    </div>
</div>
</div>